/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *   and Andreas Bresser bresser@informatik.uni-bremen.de                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CSVLOGGER_H
#define CSVLOGGER_H

#include <QString>
#include <QTextStream>
#include <QFile>
#include <QDate>
#include <QTime>
#include "../global.h"
#include "../Classes/cSettings.h"
#include "DefaultLogger.h"

class CSVLogger : public DefaultLogger
{
private:
    // Object für das Datenfile;
    QFile * csvfile;
    cSettings * settings;
    sMode * mode;
public:
    CSVLogger(cSettings * settings, sMode * mode);
    ~CSVLogger();

    //schreibe log
    void write(int * analogData);

    //erzeuge neue Log-Datei/neuen Datensatz
    void newLog();

    //alles bereit zum schreiben?
    bool ready();

    //alles schließen
    void close();
};

#endif
